function [] = syn_class_multi(varargin)
%This is a high order script that allows you to run punc_locodist2 and
%savpivots on an entire directory.
%Synatax:   [] = syn_class_multi('dirname',array)
%Input:     'dirname' = directory where the centroids are
%           'prepost_ex' = prepost parameter for savpivots for excitatory 
%               synapses, default = 4
%           'prepost_inh' = prepost parameter for savpivots for inhibitory
%               synapses, default = 7
%           'distance' = distance parameter for savpivots1v3ex, default = 2
%           'z' = z distance for distance calculations, default = 0.7
%           'x' = x distance, default = 1;
%           'y' = y distance, default = 1;
%           'secondary' = if turned on, this allows this current computer
%               to differ to another computer working on the same
%               directory.  default = 0 OFF
%Output:    none

[dirname,prepost_ex,prepost_inh,distance,z,x,y,secondary] = parse(varargin);

%pathout
pathtmp = {'PSD-SYN_VGlut1','PSD-SYN_VGluT21','PSD-SYN_VGluT2','PSD-SYN_VGluT23','PSD-SYN_VGluT1&2'};
pathtmp2 = {'vg3Geph-VGAT_GAD','vg3Geph-VGAT_GADVG3','vg3Geph-VGAT_VGluT3','vg3Geph-VGAT_VG3GAD','vg3Geph-VGAT_GAD&VGluT3'};

%now grab those directory names
dir_struct = dir(dirname);  %grab the directory information
idx = [dir_struct.isdir];   %grab all of the isdir numbers
idx(1:2) = 0;               %remove the first two directories
dirnames = {dir_struct.name};   %grab the all of the names in the root
dirnames = dirnames(idx);  %don't want the first two
dir_tmp = repmat([dirname filesep],size(dirnames'));    %replicated the directory name for appending

%prepare the output directory
warning('OFF','MATLAB:MKDIR:DirectoryExists');  %turn off this specific warning
sep_loc = strfind(dirname,filesep);
out_tmp = [dirname(1:sep_loc(end)),'Analysis'];
mkdir(dirname(1:sep_loc(end)),'Analysis')  %make the output root directories
out_tmp = repmat([out_tmp filesep],size(dirnames'));    %replicated the out_put name for appending
out_list = horzcat(cellstr(out_tmp),dirnames');      %now each cell contains the full output directory path

dirnames = cellstr([dir_tmp char(dirnames')]);      %now each cell contains the full directory path

parpool

if ~isempty(dirnames)   %if the root only have files, then no need to go further
    while 1     %we are going to dig until all sub_dirs are found
        dir_tmp = [];   %clear!
        dir_end = 0;    %reset
        out_tmp = [];
        %level in
        for i = 1:size(dirnames,1)  %for each dir_step down one
            warning('OFF','MATLAB:MKDIR:DirectoryExists');  %turn off this specific warning
            mkdir(out_list{i,1},out_list{i,2});     %copy over this directory
            curr_out = [out_list{i,1} out_list{i,2}];     %current output directory
            curr_dir = dirnames{i};     %current directory
            dir_info = dir(curr_dir); %grab the current dir
            curr_names = {dir_info.name};   %grab the all of the names
            idx = [dir_info.isdir];   %grab all of the isdir numbers
            filenames = curr_names(~idx);   %grab the files first
            idx(1:2) = 0;   %toss the first two
            dir_nxt = curr_names(idx);    %the directories
            %for every directory see if there are csvs around that fit the
            %desired criteria
            filenames = findfiletype(filenames,'.csv');  %only csvs
            %now lets look for the necessary files
            if ~isempty(filenames)  %found csv files
                disp(curr_out);  %print current directory to command line
                %initiate
                punc_data = []; all_data = [];
                exori = [];extermi = [];vg1 = [];vg2 = [];synph = [];
                ihori = [];ihtermi = [];gad = [];vg3 = [];sv2 = [];
                %parse filenames
                for j = 1:size(filenames,2)
                    if ~isempty(strfind(filenames{j},'PSD'))    %found excitatory origin
                        exori = j;
                    end
                    if ~isempty(strfind(filenames{j},'SYN '))    %found excitatory termini
                        extermi = j;
                    end
                    if ~isempty(strfind(filenames{j},'VGluT1'))    %found VGluT1
                        vg1 = j;
                    end
                    if ~isempty(strfind(filenames{j},'VGluT2'))    %found VGluT2
                        vg2 = j;
                    end
                    if ~isempty(strfind(filenames{j},'GEPH'))    %found Inhibitory origin
                        ihori = j;
                    end
                    if ~isempty(strfind(filenames{j},'VGAT'))    %found Inhibitory Termini
                        ihtermi = j;
                    end
                    if ~isempty(strfind(filenames{j},'GAD'))    %found excitatory origin
                        gad = j;
                    end
                    if ~isempty(strfind(filenames{j},'VGluT3'))    %found excitatory origin
                        vg3 = j;
                    end
                    if ~isempty(strfind(filenames{j},'SYNPH'))    %found excitatory origin
                        synph = j;
                    end
                    if ~isempty(strfind(filenames{j},'SV2'))    %found excitatory origin
                        sv2 = j;
                    end
                end
                %Now try classification
                if ~isempty(exori)&&~isempty(extermi)&&~isempty(vg1)&&~isempty(vg2)     %at least have enough to classify excitatory
                    %create current path
                    emptystatus = 0; filenum = []; classify = 0; punc_data = []; all_data = [];
                    for l = 1:size(pathtmp,2)
                        mkdir(curr_out,pathtmp{l});  %make the output root directories
                        path{l} = [curr_out,filesep,pathtmp{l}];
                        %check if current path isempty of files and if all
                        %the directories have the same number of files,
                        %which means classification is already done, then
                        %skip.
                        if ~classify %if files are empty and classification have not been determined
                            [emptystatus,filetmp] = filecheck([curr_out,filesep,pathtmp{l}]);
                            if emptystatus  %if empty
                                classify = 1;
                            elseif ~secondary %if not empty  & not secondary
                                if ~isempty(filenum)
                                    if filenum~=filetmp
                                        classify = 1;
                                    end
                                else
                                    filenum = filetmp;
                                end
                            end
                        end
                    end
                    if classify
                        [punc_data,all_data] = punc_locodist2('z',z,'x',x,'y',y,'path',curr_dir,'files',filenames);       %calculate distances
                        savpivots_1v3ex(punc_data,all_data,exori,extermi,vg1,prepost_ex,distance,vg2,prepost_ex,2,1,path);    %classify
                        %save out the ori,termi,etc. for easy checking
                        save([curr_dir,filesep,'excitatory_ori',num2str(exori),'_termi',num2str(extermi),'_vg1',num2str(vg1)...
                            ,'_vg2',num2str(vg2),'.mat'],'exori','extermi','vg1','vg2');
                    end
                end
                %now lets check if inhibitory can be done as well
                if ~isempty(ihori)&&~isempty(ihtermi)&&~isempty(gad)    %go ahead
                    mkdir(curr_out,'Geph-VGAT_GAD');
                    %check inhibitory classification
                    [emptystatus] = filecheck([curr_out,filesep,'Geph-VGAT_GAD']);  %only can check empty or not here
                    if emptystatus  %if empty classify
                        if isempty(punc_data)
                            [punc_data,all_data] = punc_locodist2('z',z,'x',x,'y',y,'path',curr_dir,'files',filenames);       %calculate distances
                        end
                        savpivots_all(punc_data,all_data,ihori,ihtermi,gad,prepost_inh,2,1,{[curr_out,filesep,'Geph-VGAT_GAD']});
                        save([curr_dir,filesep,'inhibitory_ori',num2str(ihori),'_termi',num2str(ihtermi),'_gad',num2str(gad)...
                            ,'.mat'],'ihori','ihtermi','gad');
                    end
                end
                %now lets look at VGluT3 data - we are keep this seperate
                %from the other VGluT classification for now.  We might
                %decide to integrate this later, although it will be a
                %seriously complicated mess....AHHHHHH!  Be warned
                if ~isempty(exori)&&~isempty(extermi)&&~isempty(vg3)    %go ahead
                    mkdir(curr_out,'PSD-SYN_VGluT3pre');
                    %check VGluT3 classification
                    [emptystatus] = filecheck([curr_out,filesep,'PSD-SYN_VGluT3pre']);  %only can check empty or not here
                    if emptystatus  %if empty classify
                        if isempty(punc_data)
                            [punc_data,all_data] = punc_locodist2('z',z,'x',x,'y',y,'path',curr_dir,'files',filenames);       %calculate distances
                        end
                        savpivots_all(punc_data,all_data,exori,extermi,vg3,prepost_ex,2,1,{[curr_out,filesep,'PSD-SYN_VGluT3pre']});
                        save([curr_dir,filesep,'excitatory_ori',num2str(exori),'_termi',num2str(extermi),'_vg3',num2str(vg3)...
                            ,'.mat'],'exori','extermi','vg3');
                    end
                    %Lets look at post synaptic VGluT3
                    mkdir(curr_out,'PSD-SYN_VGluT3post');
                    %check VGluT3 classification
                    [emptystatus] = filecheck([curr_out,filesep,'PSD-SYN_VGluT3post']);  %only can check empty or not here
                    if emptystatus  %if empty classify
                        if isempty(punc_data)
                            [punc_data,all_data] = punc_locodist2('z',z,'x',x,'y',y,'path',curr_dir,'files',filenames);       %calculate distances
                        end
                        savpivots_all(punc_data,all_data,exori,extermi,vg3,-4,2,1,{[curr_out,filesep,'PSD-SYN_VGluT3post']});
                        save([curr_dir,filesep,'excitatory_ori',num2str(exori),'_termi',num2str(extermi),'_vg3',num2str(vg3)...
                            ,'.mat'],'exori','extermi','vg3');
                    end
                    %SYNPH 
                    if ~isempty(synph)
                        mkdir(curr_out,'SYN-SYNPH_VGluT3');
                        %check VGluT3 classification
                        [emptystatus] = filecheck([curr_out,filesep,'SYN-SYNPH_VGluT3']);  %only can check empty or not here
                        if emptystatus  %if empty classify
                            if isempty(punc_data)
                                [punc_data,all_data] = punc_locodist2('z',z,'x',x,'y',y,'path',curr_dir,'files',filenames);       %calculate distances
                            end
                            savpivots_all(punc_data,all_data,extermi,synph,vg3,3,2,1,{[curr_out,filesep,'SYN-SYNPH_VGluT3']});
                            save([curr_dir,filesep,'presynaptic_orisynph',num2str(extermi),'_termi',num2str(synph),'_vg3',num2str(vg3)...
                                ,'.mat'],'extermi','synph','vg3');
                        end
                    end
                    %SV2 
                    if ~isempty(sv2)
                        mkdir(curr_out,'SYN-SV2_VGluT3');
                        %check VGluT3 classification
                        [emptystatus] = filecheck([curr_out,filesep,'SYN-SV2_VGluT3']);  %only can check empty or not here
                        if emptystatus  %if empty classify
                            if isempty(punc_data)
                                [punc_data,all_data] = punc_locodist2('z',z,'x',x,'y',y,'path',curr_dir,'files',filenames);       %calculate distances
                            end
                            savpivots_all(punc_data,all_data,extermi,sv2,vg3,3,2,1,{[curr_out,filesep,'SYN-SV2_VGluT3']});
                            save([curr_dir,filesep,'presynaptic_orisv2',num2str(extermi),'_termi',num2str(sv2),'_vg3',num2str(vg3)...
                                ,'.mat'],'extermi','sv2','vg3');
                        end
                    end
                    %we are going to run twice, with GEPH as the post as
                    %well
                    if ~isempty(ihori)&&~isempty(ihtermi)
                        mkdir(curr_out,'Geph-VGAT_VGluT3all');
                        %check VGluT3 classification
                        [emptystatus] = filecheck([curr_out,filesep,'Geph-VGAT_VGluT3all']);  %only can check empty or not here
                        if emptystatus  %if empty classify
                            if isempty(punc_data)
                                [punc_data,all_data] = punc_locodist2('z',z,'x',x,'y',y,'path',curr_dir,'files',filenames);       %calculate distances
                            end
                            savpivots_all(punc_data,all_data,ihori,ihtermi,vg3,4,2,1,{[curr_out,filesep,'Geph-VGAT_VGluT3all']});
                            save([curr_dir,filesep,'inhibitory_ori',num2str(ihori),'_termi',num2str(ihtermi),'_vg3',num2str(vg3)...
                                ,'.mat'],'ihori','ihtermi','vg3');
                        end
                    end
                    if ~isempty(ihori)&&~isempty(ihtermi)&&~isempty(gad)    %at least have enough to classify excitatory
                        %create current path
                        filenum = []; classify = 0;
                        for l = 1:size(pathtmp2,2)
                            mkdir(curr_out,pathtmp2{l});  %make the output root directories
                            path2{l} = [curr_out,filesep,pathtmp2{l}];
                            %check if current path isempty of files and if all
                            %the directories have the same number of files,
                            %which means classification is already done, then
                            %skip.
                            if ~classify %if files are empty and classification have not been determined
                                [emptystatus,filetmp] = filecheck([curr_out,filesep,pathtmp2{l}]);
                                if emptystatus  %if empty
                                    classify = 1;
                                elseif ~secondary %if not empty  & not secondary
                                    if ~isempty(filenum)
                                        if filenum~=filetmp
                                            classify = 1;
                                        end
                                    else
                                        filenum = filetmp;
                                    end
                                end
                            end
                        end
                        if classify
                            if isempty(punc_data)
                                [punc_data,all_data] = punc_locodist2('z',z,'x',x,'y',y,'path',curr_dir,'files',filenames);       %calculate distances
                            end
                            savpivots_1v3ex(punc_data,all_data,ihori,ihtermi,gad,prepost_inh,distance,vg3,prepost_inh,2,1,path2);    %classify
                            %save out the ori,termi,etc. for easy checking
                            save([curr_dir,filesep,'inhibitory_ori',num2str(ihori),'_termi',num2str(ihtermi),'_gad',num2str(gad)...
                                ,'_vg3',num2str(vg3),'.mat'],'ihori','ihtermi','gad','vg3');
                        end
                    end
                end
                clear punc_data all_data
            end
            
            %Iterate on
            if isempty(dir_nxt)   %bottom
                dir_end = dir_end+1;    %one path to its conclusion
                rmdir = curr_dir;   %if we are at the end, no need for this directory to be copied here.
            else    %not the bottom
                curr_dir = repmat([curr_dir filesep],size(dir_nxt'));    %replicated the directory name for appending
                dir_tmp = vertcat(dir_tmp,cellstr([curr_dir char(dir_nxt')]));      %now each cell contains the full directory path
                curr_out = repmat([curr_out filesep],size(dir_nxt'));    %replicated the out_put name for appending
                out_tmp = vertcat(out_tmp,horzcat(cellstr(curr_out),dir_nxt'));      %now each cell contains the full output directory path
            end
        end
        if dir_end==size(dirnames,1)    %all directories are at an end
            break
        else    %move next level down
            dirnames = dir_tmp;
            out_list = out_tmp;
        end
    end
end

delete(gcp('nocreate'))

%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function [dirname,prepost_ex,prepost_inh,distance,z,x,y,secondary] = parse(input)

dirname = [];
prepost_ex = 4;
prepost_inh = 7;
distance = 2;
z = 0.7;
x = 1;
y = 1;
secondary = 0;

%Parse the input
if ~isempty(input)
    for i = 1:2:size(input,2)
        if ischar(input{1,i});
            switch input{1,i}
                case 'dirname'
                    dirname = input{1,i+1};
                case 'prepost_ex'
                    prepost_ex = input{1,i+1};
                case 'prepost_inh'
                    prepost_inh = input{1,i+1};
                case 'distance'
                    distance = input{1,i+1};
                case 'z'
                    z = input{1,i+1};
                case 'x'
                    x = input{1,i+1};
                case 'y'
                    y = input{1,i+1};
                case 'secondary'
                    secondary = input{1,i+1};
                otherwise
                    warning(['Your input ',input{1,i},' is not recognized.']);
            end
        else
            error(['The parameters you entered is incorrect.  Please check help.']);
        end
    end
end

%Get the location of the images you want to open
if isempty(dirname)
    dirname = uigetdir2('','Directory where your centroids are');    %get the directory
end

%--------------------------------------------------------------------------
function [emptystatus,filenum] = filecheck(curr_dir)

dir_info = dir(curr_dir); %grab the current dir
curr_names = {dir_info.name};   %grab the all of the names
idx = [dir_info.isdir];   %grab all of the isdir numbers
filenames = curr_names(~idx);   %grab the files first
filenames = findfiletype(filenames,'.csv');  %only csvs

%is the directory empty of CSV files
if isempty(filenames)
    emptystatus = 1;
    filenum = 0;
else
    emptystatus = 0;
    filenum = size(filenames,2);
end